#include "UniqueID.h"
#include "Sct/LogicErrors.h"

#include <sstream>

using namespace std;
using namespace Sct;

namespace SctData {

UniqueID::UniqueID(string uniqueID) : uniqueID(uniqueID) {
    int dot = uniqueID.find('.');
    if (dot == uniqueID.npos) throw InvalidArgumentError("UniqueID can parse " + uniqueID + " - no run number", __FILE__, __LINE__);
    std::string temp = uniqueID.substr(0, dot);
    std::istringstream iss(temp);
    iss >> runNumber;

    int dot2 = uniqueID.find('.', ++dot);
    if (dot2 == uniqueID.npos) throw InvalidArgumentError("UniqueID can parse " + uniqueID + " - no scan number", __FILE__, __LINE__);
    temp = uniqueID.substr(dot, dot2-dot);
    std::istringstream iss2(temp);
    iss2 >> scanNumber;

    module = uniqueID.substr(++dot2);
}

UniqueID::UniqueID(unsigned int runNumber, unsigned int scanNumber, string module)
    : runNumber(runNumber), scanNumber(scanNumber), module(module) {
    ostringstream oss;
    oss << runNumber << "." << scanNumber << "." << module;
    uniqueID = oss.str();
}

string UniqueID::getUniqueID() const {
    return uniqueID;
}


UniqueID::operator string () const {
    return getUniqueID();
}

string UniqueID::getModule() const {
    return module;
}

unsigned int UniqueID::getRunNumber() const {
    return runNumber;
}

unsigned int UniqueID::getScanNumber() const {
    return scanNumber;
}

}
