#ifndef TOPHATFITOBJECT_H
#define TOPHATFITOBJECT_H

#include "FitObject.h"

using std::string;

namespace SctData{

/**
  * A fit function designed for use in, for example, the strobe-delay scan.
  * <P>A derrived class of FitObject
  * Really just the product of an Erf and a Erfc function, so that the resolution
  * on the leading and trailing edges can be different.</p>
  * @author Alan Barr
  * @date 16 Jan 2003
  */
class TopHatFitObject : public FitObject  {
public:
    /// Default Constructor
    TopHatFitObject();

    /// Constructor from root function.
    TopHatFitObject(const TF1& rootfunc);
    
    virtual shared_ptr<FitObject> clone() const throw();
    
    /// destructor does nothing
    virtual ~TopHatFitObject() throw() {;}

    virtual string getClassName() const throw() {return "SctData::TopHatFitObject";}
    
    /// Equality with ROOT TF1
    TopHatFitObject& operator=(const TF1& rootfunc) throw(LogicError) ;

protected:
    /// call the correct TF1 constructor when making a ROOT TF1
    auto_ptr<TF1> makeBasicRootTF1() const throw(LogicError) ;
    
private:
    static vector<string> createParNames();
    static vector<string> parNames;
};  // end of declaration of class TopHatFitObject

}  // end of namespace SctData

#endif // #ifndef TOPHATFITOBJECT_H

