#include "TopHatFitObject.h"
#include "FitFunctions.h"
#include "Sct/LogicErrors.h"

#include <TF1.h>
#include <TMath.h>

using namespace Sct;

namespace SctData {
    
/**
  file static method to create vector of parameter names
  */
vector<string> TopHatFitObject::createParNames() {
    vector<string> parNames(5);
    parNames[0] = "Prefact";
    parNames[1] = "MidRise";
    parNames[2] = "RiseTime";
    parNames[3] = "MidFall";
    parNames[4] = "FallTime";
    return parNames;
}

vector<string> TopHatFitObject::parNames = createParNames();    

TopHatFitObject::TopHatFitObject() : FitObject("tophat", 5, parNames) {
}

TopHatFitObject::TopHatFitObject(const TF1& f) : FitObject("tophat", 5, parNames, f){
}

shared_ptr<FitObject> TopHatFitObject::clone() const throw() {
    return shared_ptr<FitObject>(new TopHatFitObject(*this));
}

TopHatFitObject& TopHatFitObject::operator=(const TF1& f) throw(LogicError) {
    this->FitObject::operator=(f);
    return *this;
}

// Call the appropriate constructor for making a ROOT TF1 object from this
// TopHatFitObject::
auto_ptr<TF1> TopHatFitObject::makeBasicRootTF1() const throw(LogicError) {
    auto_ptr<TF1> r (new ::TF1("tophat", tophat, this->getVarMin(0), this->getVarMax(0), 5));
    if (!r.get())
        throw IllegalStateError("TopHatFitObject::makeBasicRootTF1()", __FILE__, __LINE__);
    return r;
}

} // end of namespace SctData
