#ifndef TIMEWALKTESTRESULT_H
#define TIMEWALKTESTRESULT_H

#include "TestResult.h"
#include "Sct/RangedVector.h"

namespace SctData{
class ThresholdVariable;
    /**
       The class represents the result of a pipeline test.	
       As far as I can see, this involves a defect list only, which is in TestResult.
       @author Alan Barr
    */
    class TimeWalkTestResult : public TestResult {
    public:
	TimeWalkTestResult() throw();
	
	/**
	   Constructor.
	*/
	TimeWalkTestResult(unsigned int runNumber, const string& moduleName) throw();
	
	/**
	   Destructor
	*/
	virtual ~TimeWalkTestResult() throw();
	
	//Override
	virtual string getClassName() const throw();

	class ChipTWResult{
	public:
	    ChipTWResult() : timewalk(0.), calibration(0.) {}
	    float timewalk; ///<max change in delay setting
	    float calibration; ///<calibration of width should=25ns.
	};
	
	/**
	   get ChipResult @param index chip in range 0->11 
	*/
	ChipTWResult& getChipResult(const unsigned index);
	/**
	   const get ChipResult @index chip in range 0->11 
	*/
	const ChipTWResult& getChipResult(const unsigned index) const;
    private:
	RangedVector<ChipTWResult> chipResults;

    };
}// end of namespace SctData
#endif //#ifndef TIMEWALKTESTRESULT_H
