#include "TimeWalkTestResult.h"
#include "NullVariable.h"
#include "DefaultVariable.h"
#include <CommonWithDsp/ABCD/ABCDscans.h>

///@todo check that ST_COMPRESSION is really the right variable!

namespace SctData{
    TimeWalkTestResult::TimeWalkTestResult() throw() : chipResults("TimeWalkChipResult") {
	chipResults.resize(nChipModule);
    }
    
    TimeWalkTestResult::TimeWalkTestResult(unsigned int runNumber, const string& moduleName) throw()
	: TestResult(runNumber, moduleName, NullVariable::instance(), 
		     *DefaultVariable::instance(ST_COMPRESSION)), 
	  chipResults("TimeWalkChipResult"){
	chipResults.resize(nChipModule);
    }
    
    TimeWalkTestResult::~TimeWalkTestResult() throw() {}

    string TimeWalkTestResult::getClassName() const throw(){
	return string("SctData::TimeWalkTestResult");
    }

    const TimeWalkTestResult::ChipTWResult& TimeWalkTestResult::getChipResult(const unsigned index) const{
	return chipResults[index];
    }
    
    TimeWalkTestResult::ChipTWResult& TimeWalkTestResult::getChipResult(const unsigned index){
	return chipResults[index];
    }

}
