#ifndef THRESHOLDVARIABLE_H
#define THRESHOLDVARIABLE_H

#include "ConfigurationVariable.h"
#include "ModuleConfiguration.h"

namespace SctData {
    
class ThresholdVariable : public ConfigurationVariable {
public:
    virtual double getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual void setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw(); 
protected:
    ThresholdVariable(unsigned int typeRep, std::string strategyDescription);
};


inline ThresholdVariable::ThresholdVariable(unsigned int typeRep, std::string strategyDescription) : ConfigurationVariable(typeRep, "Threshold", strategyDescription) {}

inline double ThresholdVariable::getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw() {
    return config.getChipConfiguration(chip).getThreshold();
}

///@todo Check parameters here?
inline void ThresholdVariable::setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw() {
    config.getChipConfiguration(chip).setThreshold((unsigned char) actualPt);
}


}

#endif //#ifndef THRESHOLDVARIABLE_H
