#ifndef STROBEDELAYVARIABLE_H
#define STROBEDELAYVARIABLE_H

#include "ConfigurationVariable.h"
#include "ModuleConfiguration.h"

namespace SctData {
    
class StrobeDelayVariable : public ConfigurationVariable {
public:
    static const StrobeDelayVariable& instance() throw();
    
    virtual double getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual double getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw();    
    virtual double getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw();   
     
    virtual double getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual void setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw(); 
    
private:
    StrobeDelayVariable();
    unsigned char getActualPoint(double logicalPt) const throw();
    double getLogicalPoint(unsigned char actualPt) const throw();

};

///@todo : Fix this!!! To get ns from DAC ??? 
inline unsigned char StrobeDelayVariable::getActualPoint(double logicalPt) const throw() {
    return (unsigned char)(logicalPt/2.5);
}

inline double StrobeDelayVariable::getLogicalPoint(unsigned char actualPt) const throw() {
    return 2.5 * actualPt;
}


}

#endif //#ifndef THRESHOLDVARIABLE_H
