#include "StrobeDelayVariable.h"
#include <CommonWithDsp/ABCD/ABCDscans.h>


namespace SctData {
    
const StrobeDelayVariable& StrobeDelayVariable::instance() throw() {
    static StrobeDelayVariable* ob = new StrobeDelayVariable();
    return *ob;
}

StrobeDelayVariable::StrobeDelayVariable() : ConfigurationVariable(ST_STROBE_DELAY, "Strobe Delay", "Set in ns") {}

double StrobeDelayVariable::getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw() {
    return config.getChipConfiguration(chip).getStrobeDelay();
}

///@todo Check parameters here?
void StrobeDelayVariable::setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw() {
    config.getChipConfiguration(chip).setStrobeDelay((unsigned char) actualPt);
}

double StrobeDelayVariable::getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw(){
    return getActualPoint(logicalPt);
}

double StrobeDelayVariable::getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw(){
    return getActualPoint(logicalPt);
}

double StrobeDelayVariable::getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return getActualPoint(logicalPt);
}


double StrobeDelayVariable::getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw() {
    return getLogicalPoint(actualPt);
}

double StrobeDelayVariable::getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw() {
    return getLogicalPoint(actualPt);
}

double StrobeDelayVariable::getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw() {
    return getLogicalPoint(actualPt);
}


}
