#include "StandardDefects.h"
#include "DefectPrototype.h"

namespace SctData {

const DefectPrototype StandardDefects::DEAD       (1,  UNUSEABLE, "DEAD", "Dead channel - output always <1%%", 0.01);
const DefectPrototype StandardDefects::STUCKON    (2,  UNUSEABLE, "STUCKON", "Dead channel - output always > 98%% occupancy", 0.98);
const DefectPrototype StandardDefects::UNDER      (3,  DODGY,     "UNDER", "Occupancy never reaches 100%%", 1.);
const DefectPrototype StandardDefects::OVER       (4,  DODGY,     "OVER", "Occupancy greater than 100%%", 1.);
const DefectPrototype StandardDefects::BADFIT     (5,  SERIOUS,   "BADFIT", "The data could not be fitted well - possible it has a chi2 per dof greater than: %g", 5000.);
const DefectPrototype StandardDefects::LO_GAIN    (9,  UNUSEABLE, "LO_GAIN", "Gain is less than %g*chip average", 0.75);
const DefectPrototype StandardDefects::HI_GAIN    (10, UNUSEABLE, "HI_GAIN", "Gain is higher than %g*chip average", 1.25);
const DefectPrototype StandardDefects::LO_OFFSET  (11, UNUSEABLE, "LO_OFFSET", "Offset is less than %g", -100);
const DefectPrototype StandardDefects::HI_OFFSET  (12, UNUSEABLE, "HI_OFFSET", "Offset is higher than %g", 120);
const DefectPrototype StandardDefects::UNBONDED   (13, DODGY,     "UNBONDED", "Noise is less than %g", 800);
const DefectPrototype StandardDefects::PARTBONDED (14, DODGY,     "PARTBONDED", "Noise is less than %g", 1100);
const DefectPrototype StandardDefects::NOISY      (15, DODGY,     "NOISY", "Noise is > %g*chip average", 1.15);
const DefectPrototype StandardDefects::MEAN_ERROR (16, SERIOUS,   "MEAN_ERROR", "Error in the mean", 0);
const DefectPrototype StandardDefects::SIG_ERROR  (17, SERIOUS,   "SIG_ERROR", "Error in the sigma", 0);
const DefectPrototype StandardDefects::NOINIT     (18, SERIOUS,   "NOINIT", "Couldn't initialize fit", 0);
const DefectPrototype StandardDefects::NO_HI      (19, DODGY,     "NO_HI", "High noise occupancy", 0.0005);
const DefectPrototype StandardDefects::DEAD_CELL  (20, SERIOUS,   "DEAD_CELL","Dead cell in the pipeline",0.);
const DefectPrototype StandardDefects::STUCK_CELL (21, SERIOUS,   "STUCK_CELL","Stuck cell in the pipeline",0.);
const DefectPrototype StandardDefects::TR_RANGE   (22, UNUSEABLE, "TR_RANGE","Unusual chip trim step size",0.);
const DefectPrototype StandardDefects::TR_STEP    (23, DODGY,     "TR_STEP","Channel trim step size different from chip",4.);
const DefectPrototype StandardDefects::TR_OFFSET  (24, DODGY,     "TR_OFFSET","Channel trim range offset different from chip",4.);
const DefectPrototype StandardDefects::TR_NOTRIM  (25, UNUSEABLE, "TR_NOTRIM","Untrimmable channel",0.);
const DefectPrototype StandardDefects::TOKEN      (26, DODGY,     "TOKEN","Direct token fails",0.);
const DefectPrototype StandardDefects::RTOKEN     (27, DODGY,     "RTOKEN","Bypass token fails",0.);
const DefectPrototype StandardDefects::TW_HI      (28, DODGY,     "TW_HI","Time walk too big",16.);
const DefectPrototype StandardDefects::TW_LO      (29, DODGY,     "TW_LO","Time walk too small",5.);
const DefectPrototype StandardDefects::SD_LO      (30, DODGY,     "SD_LO", "Strobe delay rise < 0 or fall < %i", 28);
const DefectPrototype StandardDefects::SD_HI      (31, DODGY,     "SD_HI", "Strobe delay rise > %i or fall > 63", 35);
const DefectPrototype StandardDefects::VLO_GAIN   (32, UNUSEABLE, "VLO_GAIN", "Gain is less than %g*chip average", 0.3);
const DefectPrototype StandardDefects::V_NOISY    (33, UNUSEABLE, "V_NOISY", "Noise is > %g*chip average", 1.25);
}
