#ifndef SINGLEVARIABLETESTRESULT_H
#define SINGLEVARIABLETESTRESULT_H

#include "FitObject.h"
#include "TestResult.h"

class TF1;
class TGraph;

using namespace std;

namespace SctData {
	
  /**
   * A derived class of TestResult, containing the results data for a Strobe Delay Test.
   * Such a test requires only a single scan.<P>
   * The result of the analysis is an optimum delay value for each of the 12 chips.
   * @author Alan Barr
   */
class SingleVariableTestResult : public TestResult {
public:
    SingleVariableTestResult() throw();

    ~SingleVariableTestResult() throw() {}
    
    /**
    Constructor.  
    */
    SingleVariableTestResult(const ConfigurationVariable& scanVariable,  const unsigned int runNumber, const string& moduleName) throw() ;
      
    //override
    virtual string getClassName() const throw()=0;
  
    /**
      Override addScan to ensure there is only 1 scanNumber
      */
    virtual void addScan(unsigned int scanNumber, double testPoint = 0) throw (LogicError);    
    
    /// get the number of optmimised chip delays (usually 0 or 12).
    virtual unsigned int getNOptima() const throw() {return m_optima.size();}
    
    virtual void setNOptima(unsigned int n) throw() {m_optima.resize(n);}
    /// set the optimum for chip i to value 
    virtual void setOptimum(unsigned i, double value) throw (Sct::LogicError); 
    /// get the value of one of the chip delays (chip `i').
    virtual double getOptimum(unsigned i) const throw(Sct::LogicError);
 private:
    vector<double> m_optima; 		///< the optimum value of the delay.
};
  
} // end of namespace SctData

#endif //#ifndef SINGLEVARIABLETESTRESULT_H
