#include "ResultHeader.h"
#include "ConfigurationVariable.h"
#include "UniqueID.h"
#include "NullVariable.h"
#include <iostream>
#include <sstream>
#include <boost/date_time/posix_time/posix_time.hpp>

using namespace Sct;
using namespace std;
using namespace boost::posix_time;

namespace SctData {

ResultHeader::ResultHeader(unsigned int scanNumber, unsigned int runNumber, string moduleName, const ConfigurationVariable& variable) :
                       scanNumber(scanNumber), runNumber(runNumber), moduleName(moduleName), 
		       startTime("19700101T000000"), endTime("1970101T000000"), variable(&variable) {}

ResultHeader::ResultHeader() : scanNumber(0), runNumber(0), moduleName(""), 
    startTime("19700101T000000"), endTime("1970101T000000"), variable(&NullVariable::instance()) {}

bool ResultHeader::operator==(const ResultHeader& scan) const {
    if (scanNumber == scan.scanNumber && runNumber == scan.runNumber &&
            moduleName == scan.moduleName && *variable == *scan.variable)
        return true;
    else
        return false;
}

//Streamable and Serializable overrides
string ResultHeader::getClassName() const throw(){
    return "SctData::ResultHeader";
}

string ResultHeader::getUniqueID() const throw() {
    return getUniqueID(runNumber, scanNumber, moduleName);
}

string ResultHeader::getUniqueID(unsigned int runNumber, unsigned int scanNumber, const string& moduleName) {
    return UniqueID(runNumber, scanNumber, moduleName);
}

ptime ResultHeader::getStartTime() const {
    return from_iso_string(startTime);
}
    
void ResultHeader::setStartTime(ptime start) {
    startTime = to_iso_string(start);
    startTime = startTime.substr(0, 15);
}
    
ptime ResultHeader::getEndTime() const {
    return from_iso_string(endTime);
}
    
void ResultHeader::setEndTime(ptime end) {
    endTime = to_iso_string(end);
    endTime = endTime.substr(0, 15);
}

}
