#ifndef RAWSCANRESULTIOHELPER_H
#define RAWSCANRESULTIOHELPER_H

#include <memory>
#include "CommonWithDsp/processor.h"
#include "boost/shared_ptr.hpp"

class TH1D;
class TH2D;
using std::auto_ptr;

namespace SctData {
	
class RawScanResult;

/** IO helper only for RawScanResult */
 
class RawScanResultIOHelper {
public:
	RawScanResultIOHelper() throw() ;
	RawScanResult& create() throw() ;
	void set(const RawScanResult& ob) throw();
	TH2D* getScanData(int iLink) const throw();
	boost::shared_ptr<TH2D> getOccupancyPerEvent(int iChip) const throw();
	void setScanData(int iLink, auto_ptr<TH2D> data) const throw();
	void setOccupancyPerEvent(int iChip, auto_ptr<TH2D> occ) const throw();
	void setDataType(UINT16 type) const throw();
	//** resizes vector of pointers, but does not create */
	void setNumberOccupancyHists(const unsigned short n);
protected:
	mutable RawScanResult* raw;
};
}

#endif //#ifndef RAWSCANRESULTIOHELPER_H
