#include "Sct/SctParameters.h"
#include "Sct/OutOfRangeError.h"

#include "RawScanResult.h"
#include "ModuleConfiguration.h"
#include "../ScanResultWriter/dataTypes.h"
#include <TH1.h>
#include <TH2.h>
#include <TROOT.h>

#include <sstream>

using namespace Sct;
using namespace std;


namespace SctData {

RawScanResult::RawScanResult(const ResultHeader& scan, const ModuleConfiguration& module, 
			     const ScanPoints& points, TH2D& scan_link0,  TH2D& scan_link1) throw() :
    ScanResult(scan, module, points), scanData_link0(&scan_link0),  scanData_link1(&scan_link1) , occ_chip("Chip Occupancy Histograms"), m_dataType(SR_DT_ROOTHIST) {}
    
//Only for the builder:
RawScanResult::RawScanResult() throw () : occ_chip("Chip Occupancy Histograms"), m_dataType(SR_DT_ROOTHIST){
}

RawScanResult::~RawScanResult() throw() {
}

string RawScanResult::getClassName() const throw() {
    return "SctData::RawScanResult";
}

string RawScanResult::getUniqueID() const throw() {
    return getHeader().getUniqueID();
}


string RawScanResult::getUniqueID(const ResultHeader& header) throw() {
    return header.getUniqueID();
}

UINT16 RawScanResult::getDataType() const throw() {
  return m_dataType;
}

TH2D& RawScanResult::getScanData(unsigned ilink) const throw(LogicError) {
    TH2D* data=0;
    if (ilink == 0) {
	data= scanData_link0.get();
    } else if ( ilink==1 )  {
	data= scanData_link1.get();
    } else {
	throw OutOfRangeError<unsigned>("RawScanResult::getScanData ilink ", __FILE__, __LINE__, ilink,0,1); 
    }
    if (!data) throw InvariantViolatedError("RawScanResult::getScanData no scan data", __FILE__, __LINE__) ;
    return *data;
}

unsigned RawScanResult::nOccupancyPerEvent() const{
  return occ_chip.size();
}

TH2D& RawScanResult::getOccupancyPerEvent(unsigned ichip) const throw(LogicError) {
    if (occ_chip[ichip].get()) {
      return *occ_chip[ichip];
    }else{
      throw Sct::InvariantViolatedError("RawScanResult::getOccupancyPerEvent no scan data", __FILE__, __LINE__) ;
    }
}

}


