#ifndef NOISEOCCUPANCYTESTRESULT_H
#define NOISEOCCUPANCYTESTRESULT_H

#include "TestResult.h"
#include "Sct/RangedVector.h"
#include <boost/shared_ptr.hpp>

class TF1;
class TGraph;
class TH1;

namespace SctData {
class ThresholdVariable;    
class ResponseCurve;
class ChipNOResult;

    /**
     * small class holds all data relevant to one chip.
     */
    class ChipNOResult {
    public:
	ChipNOResult() : mean(0.), rms(0.){;}
	/// Make a result with graph, fit, mean and rms.
	/// @param graph of log occupancy vs threshold^2
	/// @param fit to that graph
	/// @param mean noise on that chip
	/// @param rms noise on that chip
	ChipNOResult(shared_ptr<TGraph>g, shared_ptr<TF1>f, 
		     double m, double r) : 
	    graph(g), fit(f), mean(m), rms(r) {;}
	~ChipNOResult(){;}
	shared_ptr<TGraph> graph;
	shared_ptr<TF1> fit;
	double mean;
	double rms;
	double offset;
	double getNoise() const throw();
	ChipNOResult& operator=(const ChipNOResult&) throw();
    };




/**
The class represents the Noise Occupancy test.	
It performs the test by constructing the graph of log occupancy against threshold(in fC)^2 then fitting 
a straight line to it.  To do this, it needs the inverse response curve to convert threshold in mV to 
threshold in fC.
@author Matthew Palmer
*/
class NoiseOccupancyTestResult : public TestResult {
public:
    NoiseOccupancyTestResult() throw();
    
    /**
    Constructor.
    */
    NoiseOccupancyTestResult(unsigned int runNumber, const string& moduleName, const ThresholdVariable& scanVariable) throw();

    /**
    Destructor
    */
    virtual ~NoiseOccupancyTestResult() throw();

    //Override
    virtual string getClassName() const throw();

    /**
      Override addScan to ensure there is only 1 scanNumber
      */
    virtual void addScan(const unsigned scanNumber, const double testPoint = 0) throw (LogicError);
    
    /// get all the results for a particular chip @{
    ChipNOResult& getChipResult(unsigned ichip){ return chipResult[ichip];}
    const ChipNOResult& getChipResult(unsigned ichip) const { return chipResult[ichip];}
    ///@}
    /// source of fit functions. In this function since it is needed by IO as well as during building.
    static auto_ptr<TF1> createFitFunction() throw();
private:
    RangedVector<ChipNOResult> chipResult;
    NoiseOccupancyTestResult& operator=(const NoiseOccupancyTestResult&);
    friend class NoiseOccupancyTestResultIOHelper;
};

}

#endif //#ifndef NOISEOCCUPANCYTESTRESULT_H
