#include "NoiseOccupancyTestResult.h"
#include "RawScanResult.h"
#include "ThresholdVariable.h"
#include "NullVariable.h"
#include "Sct/SctParameters.h"

#include <TF1.h>
#include <TGraph.h>
#include <TGraphAsymmErrors.h>

#include <iostream>

using namespace std;

namespace SctData {
    
    NoiseOccupancyTestResult::NoiseOccupancyTestResult() throw() :
	chipResult("NoiseOccupancyTestResult::chipResult")
	{
	chipResult.resize(nChipModule);
    }
    
    
    NoiseOccupancyTestResult::NoiseOccupancyTestResult(const unsigned runNumber, const string& moduleName, const ThresholdVariable& scanVariable) throw() :
	TestResult(runNumber, moduleName, NullVariable::instance(), scanVariable), 
	chipResult("NoiseOccupancyTestResult::chipResult")
	{
	chipResult.resize(nChipModule);
    }
    
    NoiseOccupancyTestResult::~NoiseOccupancyTestResult() throw() {
    }
    
    string NoiseOccupancyTestResult::getClassName() const throw() {
	return "SctData::NoiseOccupancyTestResult";
    }
    
    void NoiseOccupancyTestResult::addScan(const unsigned scanNumber, const double testPoint) throw (LogicError) {
	if (data.size() != 0) throw InvariantViolatedError("NoiseOccupancyTestResult::addScan - can only contain 1 scan", __FILE__, __LINE__);
	TestResult::addScan(scanNumber, testPoint);
    }
    
    
    ///@todo More checks. 
    ///@note What is 6250? Its a  magic number that converts noise in fC to noise in ENC.
    ///Get noise at 1fC
    double ChipNOResult::getNoise() const throw() {
	if (!fit.get()) return 0.;
	return 6250.*sqrt(-1/(2*fit->GetParameter(1)));
	//return 6250.*sqrt(1/(2*fit->GetParameter(1)));
    }
    
    ChipNOResult& ChipNOResult::operator=(const ChipNOResult& copyme) throw(){
	mean=copyme.mean; rms=copyme.rms; 
	fit=copyme.fit; graph=copyme.graph;
	return *this;
    }
    
    double lnerfc(double* x, double* par) {
	return par[0] + log(TMath::Erfc(sqrt(par[1]*x[0])));
    }
    
    
    auto_ptr<TF1> NoiseOccupancyTestResult::createFitFunction() throw() {
	return auto_ptr<TF1> (new TF1("fitfn", "pol1", 0.3, 2)) ;
	//return auto_ptr<TF1> (new TF1("fitfn", "[0]-[1]*x-1./2.*log(x)", 0.5, 2)) ;
	//return auto_ptr<TF1> (new TF1("fitfn", "[0]+[1]*x-1./2.*log(x)+log(1.-[1]/(2.*pow(x,1.5)))", 0.5, 2)) ;
	//auto_ptr<TF1> f(new TF1("fitfn", lnerfc, 0.5, 2, 2)) ;
	//f->SetParameter(0, 1);
	//f->SetParameter(1, 1);
	//return f;
    }
    
}

