#include "ModuleConfiguration.h"
#include <string>
#include <algorithm>
#include "Sct/SctParameters.h"

using std::string;
using namespace Sct;

namespace SctData {
    
ModuleConfiguration::ModuleConfiguration() throw() {
    //Initialize ABCDModule
    std::fill_n((char*)&configuration, sizeof(configuration), 0);
    
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
	shared_ptr<ChipConfiguration> chipConfig (new ChipConfiguration(configuration.chip[i]));
	chipConfigs.push_back(chipConfig);
    }
}

ModuleConfiguration::~ModuleConfiguration() throw() {    
}

ModuleConfiguration::ModuleConfiguration(const ModuleConfiguration& config) throw() {
    this->configuration = config.configuration;
    
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
	shared_ptr<ChipConfiguration> chipConfig (new ChipConfiguration(configuration.chip[i]));
	chipConfigs.push_back(chipConfig);
    }    
}

ModuleConfiguration& ModuleConfiguration::operator=(const ModuleConfiguration& config) throw() {
    this->configuration = config.configuration;    
    return *this;
}

bool ModuleConfiguration::channelIsMasked(const unsigned int ichannel) const throw(){
    return getChipConfiguration(ichannel/nChannelChip).isMasked(ichannel%nChannelChip);
}


string ModuleConfiguration::getClassName() const throw() {
    return string("SctData::ModuleConfiguration");
}	

ChipConfiguration& ModuleConfiguration::getChipConfiguration(const unsigned int chip) throw() {
    return *chipConfigs[chip];
}

const ChipConfiguration& ModuleConfiguration::getChipConfiguration(const unsigned int chip) const throw() {
    return *chipConfigs[chip];
}
 
const ABCDModule& ModuleConfiguration::getABCDModule() const {
    return configuration;
}

ABCDModule& ModuleConfiguration::getABCDModule() {
    return configuration;
}

}

