#include "Sct/VersionNotSupportedException.h"
#include "Sct/IoExceptions.h"

#include "../TrimRangeTestResult.h"
#include "TrimRangeTestResultStreamer_v1.h"

#include <TF1.h>
#include <vector>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TrimRangeTestResultStreamer_v1::s_version=1;

TrimRangeTestResultStreamer_v1::TrimRangeTestResultStreamer_v1() throw() {
  //  std::cout << "v1 ... " << getVersion() << endl;
}

  bool TrimRangeTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::TrimRangeTestResult",  auto_ptr<Streamer>(new TrimRangeTestResultStreamer_v1()));


shared_ptr<Streamable> TrimRangeTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new TrimRangeTestResult());
    read(in, *ad, manager);
    return ad;
}

void TrimRangeTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //cout << "TrimRangeTestResultIS::publishGuts" << endl;
    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");

    const TrimRangeTestResult& mytest = dynamic_cast <const TrimRangeTestResult&>(ob);

    out << (int) mytest.chipTrimData.size();
    for (unsigned int i = 0; i < mytest.chipTrimData.size(); ++i) {
        writeData(out, *mytest.chipTrimData[i], manager);
    }

    out << (int) mytest.chipTrim.size();
    for (unsigned int i = 0; i < mytest.chipTrim.size(); ++i) {
        writeTrim(out, *mytest.chipTrim[i], manager);
    }

    out << mytest.charge << mytest.type << mytest.algorithm;
}

void TrimRangeTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");

    TrimRangeTestResult& mytest = dynamic_cast < TrimRangeTestResult & >(ob);

    int n = 0;
    in >> n;
    mytest.chipTrimData.resize(n);
    for (unsigned int i = 0; i<n; ++i) {
	mytest.chipTrimData[i] = shared_ptr<TrimRangeTestResult::ChipTrimData>(new TrimRangeTestResult::ChipTrimData() );
        readData(in, mytest, const_cast<TrimRangeTestResult::ChipTrimData&>(*mytest.chipTrimData[i]), manager);
    }

    in >> n;
    mytest.chipTrim.resize(n);
    for (unsigned int i = 0; i<n; ++i) {
	mytest.chipTrim[i] = shared_ptr<TrimRangeTestResult::ChipTrim>(new TrimRangeTestResult::ChipTrim() );
        readTrim(in, mytest, const_cast<TrimRangeTestResult::ChipTrim&>(*mytest.chipTrim[i]), manager);
    }

    in >> mytest.charge >> mytest.type >> mytest.algorithm;
}

    void TrimRangeTestResultStreamer_v1::writeTrim(OStream& out, const TrimRangeTestResult::ChipTrim& trim, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError){
	out << trim.target << (int) trim.range;
	if (trim.channelTrim.size()!=nChannelChip){
	    ostringstream os;
	    os << "TrimRangeTestResultStreamer_v1::writeTrim, bad size " << trim.channelTrim.size();
	    throw StreamCorruptedException(os.str(), __FILE__, __LINE__ );
	}
	out << (int) trim.channelTrim.size();
	for (unsigned i=0; i<trim.channelTrim.size(); ++i){
	    Stat<TrimRangeTestResult::Trim> t=trim.channelTrim.getAt(i);
	    int trim_i = t.value.trim;
	    out << t.valid << trim_i << t.value.vthr;
	}
    }

    void TrimRangeTestResultStreamer_v1::readTrim(IStream& in, TrimRangeTestResult& mytest, TrimRangeTestResult::ChipTrim& trim, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError){
	in >> trim.target;
	int range; in >> range ; trim.range=range;
	int size; in >> size; trim.channelTrim.resize(size);
	if (size!=nChannelChip){
	    ostringstream os;
	    os << "TrimRangeTestResultStreamer_v1::readTrim, bad size " << trim.channelTrim.size();
	    throw StreamCorruptedException(os.str(), __FILE__, __LINE__ );
	}
	for (unsigned i=0; i<size; ++i){
	    Stat<TrimRangeTestResult::Trim>& t=trim.channelTrim.modifyAt(i);
	    int trim_i;
	    in >> t.valid >> trim_i >> t.value.vthr;
	    t.value.trim=trim_i;
	}
    }

void TrimRangeTestResultStreamer_v1::writeData(OStream& out, const TrimRangeTestResult::ChipTrimData& chiptrim, const IOManager& manager) const throw(LogicError, IoError) {
    out << (int) chiptrim.channelData.size();
    for (unsigned i=0; i<chiptrim.channelData.size(); ++i){
	Stat<TrimRangeTestResult::TrimData> d=chiptrim.channelData.getAt(i);
	
	out << d.valid << d.value.p0 << d.value.p1;
	out << (int) d.value.graph.size();
	for (unsigned ipt=0; ipt<d.value.graph.size(); ++ipt){
	    out << d.value.graph[ipt].first << d.value.graph[ipt].second;
	}
    }
}

void TrimRangeTestResultStreamer_v1::readData(IStream& in, TrimRangeTestResult& mytest, TrimRangeTestResult::ChipTrimData& chipTrim, const IOManager& manager) const throw(LogicError, IoError) {
    int size; in >> size; 
    chipTrim.channelData.resize(nChannelChip);
    for (unsigned i=0; i<nChannelChip; ++i){
	Stat<TrimRangeTestResult::TrimData>& d=chipTrim.channelData.modifyAt(i);
	in >> d.valid >> d.value.p0 >> d.value.p1;
	
	in >> size; d.value.graph.resize(size);
	for (int ipt=0; ipt<size; ++ipt){
	    float first, second;
	    in >> first; in >> second;
	    d.value.graph[ipt]=pair<float,float>(first,second);
	}
    }
}
}


} 

