#include "TimeWalkTestResultStreamer_v1.h"

using namespace Sct;

namespace SctData {
    namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TimeWalkTestResultStreamer_v1::s_version=1;

	TimeWalkTestResultStreamer_v1::TimeWalkTestResultStreamer_v1() throw() {}
	
bool TimeWalkTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::TimeWalkTestResult",  auto_ptr<Streamer>(new TimeWalkTestResultStreamer_v1()));
	
	shared_ptr<Streamable> TimeWalkTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError){
	    boost::shared_ptr<Streamable> ad (new TimeWalkTestResult());
	    read(in, *ad, manager);
	    return ad;
	}
	
	void TimeWalkTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
	    //Let superclass do its work
	    manager.writeImpl(out, ob, "SctData::TestResult");
	    
	    //cout << "TimeWalkTestResultStreamer_v1 doing dynamic_cast" << endl;
	    const TimeWalkTestResult& mytest = dynamic_cast<const TimeWalkTestResult&>(ob);
	    
	    for (unsigned int ichip=0; ichip<nChipModule; ichip++) {
		writeChipResult(out, mytest.getChipResult(ichip), manager);
	    }
	}
	
	void TimeWalkTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
	    manager.readImpl(in, ob, "SctData::TestResult");
	    
	    TimeWalkTestResult& mytest = dynamic_cast<TimeWalkTestResult&>(ob);
	    
	    for (unsigned int ichip=0; ichip<nChipModule; ichip++) {
		readChipResult(in, mytest.getChipResult(ichip), manager);
	    }
	}
	
	void TimeWalkTestResultStreamer_v1::writeChipResult(OStream& out, const TimeWalkTestResult::ChipTWResult& c, const IOManager& manager) const throw (LogicError, IoError) {
	    out << c.timewalk << c.calibration;
	}
	
	void TimeWalkTestResultStreamer_v1::readChipResult(IStream& in, TimeWalkTestResult::ChipTWResult& c, const IOManager& manager) const throw(LogicError, IoError) {
	    in >> c.timewalk >> c.calibration;
	}
	
    } 
}
