#ifndef SCTDATA_IO_TESTRESULTSTREAMER_V2_H
#define SCTDATA_IO_TESTRESULTSTREAMER_V2_H

#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
namespace IO {

/**
 * Implimentation of the IS publish and refresh methods for the abstract class TestResult.
 * The published and refreshed elements are:
 * -> run number -> module name -> the `special' point. 
 * -> a list of the scan numbers and the scan `test point' values.
 * -> the defect list.
 * <P> Doesn't implement createObject.
 */

class TestResultStreamer_v3 : public virtual Streamer {
public:
virtual unsigned getVersion() const throw() {return s_version;}	
protected:
    TestResultStreamer_v3() throw();
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual shared_ptr<Streamable> read(IStream&, const IOManager&) const throw(LogicError, IoError);
    static unsigned s_version;
    static bool inMap;

};


}
}
#endif // #ifndef SCTDATA_IO_TESTRESULTSTREAMER_V2_H
