#include "TestResultStreamer_v1.h"
#include "../TestResult.h"
#include "../ConfigurationVariable.h"

#include <string>

using namespace std;
using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TestResultStreamer_v1::s_version=2;
	
bool TestResultStreamer_v1::inMap = IOManager::addToMap("SctData::TestResult",  std::auto_ptr<Streamer>(new TestResultStreamer_v1()));
	
TestResultStreamer_v1::TestResultStreamer_v1() throw() {}

shared_ptr<Streamable> TestResultStreamer_v1::read(IStream&, const IOManager&) const throw(LogicError, IoError) {
    throw Sct::LogicError("Cannot make a TestResult - abstract class",__FILE__,__LINE__);
}

void TestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    // cout <<"TestResultIS publishing"<<endl;
    const TestResult& mytest = dynamic_cast<const TestResult&>(ob);
    
    manager.writeImpl(out, mytest.getHeader(), false);
    manager.writeImpl(out, mytest.getTestVariable(), false);

    out << mytest.getNScans();
    for (unsigned int i=0; i<mytest.getNScans(); ++i) {
        out << mytest.getScanNumberAt(i) << mytest.getTestPointAt(i);
    }
    manager.writeImpl(out, mytest.getDefects() , false);
    
    out << mytest.getPassed();
    out << mytest.getProblem();
    vector<string> comments = mytest.getComments();
    out << comments.size();
    for (unsigned int i=0; i<comments.size(); ++i) {
	out << comments[i];
    }
}

void TestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {  
    TestResult& mytest = dynamic_cast<TestResult&>(ob);

    //cout << "TestResultIS refreshing" << endl;

    manager.readImpl(in, mytest.getHeader(), false);
    shared_ptr<Streamable> ob2 = manager.readImpl(in, "SctData::ConfigurationVariable");
    mytest.setTestVariable(*boost::dynamic_pointer_cast<ConfigurationVariable>(ob2));	///Should always succeed!
        
    //cout << "   found "<<runNumber << moduleName << endl;

    unsigned int size=0;
    in >> size;
    for (unsigned int i=0; i<size; ++i) {
        unsigned int scanNumber;
        double testPoint;
        in >> scanNumber >> testPoint;
        mytest.addScan(scanNumber, testPoint);
        //cout << "TestResultIS refresh : added scan "<<scanNumber<<endl;
    }
    manager.readImpl(in, mytest.getDefects(), false);
    
    bool passed, problem;
    unsigned int nComments;    
    string comment;
    in >> passed;   mytest.setPassed(passed);
    in >> problem;  mytest.setProblem(problem);
    
    in >> nComments;
    for (unsigned int i=0; i<nComments; ++i) {
	in >> comment;	mytest.addComment(comment);
    }
    
    //cout << "TestResultIS refresh done" << endl;
}
}
}

