#include "TGraphStreamer_v1.h"
#include "TGraph.h"
#include "../RootStreamableAdapter.h"

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TGraphStreamer_v1::s_version=1;

bool TGraphStreamer_v1::inMap = IOManager::addToMap(TGraph::Class()->GetName(),  auto_ptr<Streamer>(new TGraphStreamer_v1()));

TGraphStreamer_v1::TGraphStreamer_v1() throw() {}

void TGraphStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const RootStreamableAdapter& ad = dynamic_cast<const RootStreamableAdapter&>(ob);
    TGraph* graph = (TGraph*)ad.getObject();
    out << static_cast<unsigned int> ( graph->GetN() );
    out.put(graph->GetX(), graph->GetN() );
    out.put(graph->GetY(), graph->GetN() );
}

shared_ptr<Streamable> TGraphStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new RootStreamableAdapter(*new TGraph()));
    read(in, *ad, manager);
    return ad;
}

void TGraphStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    RootStreamableAdapter& ad = dynamic_cast<RootStreamableAdapter&>(ob);
    TGraph* graph = (TGraph*)ad.getObject();
    unsigned int n = 0;
    in >> n;
    double x[n], y[n];
    in.get(x, n);
    in.get(y, n);
    if (n>0) graph->Set(n);
    for (unsigned int i=0; i<n; ++i)
        graph->SetPoint(i, x[i], y[i]);
}
}
}
