#ifndef SCTDATA_IO_TF1STREAMER_H
#define SCTDATA_IO_TF1STREAMER_H

#include "Sct/Streamer.h"
#include "Sct/Exception.h"

using namespace Sct;

namespace SctData {
namespace IO {
/**
 * Allows serialization of root TF1 object to IS.
 * One can only make a TF1IS from a TF1.
 * NB cannot make the correct TF1, so no function refreshGuts(ISistream& in) const;
 * elements transfered are:
 * -> number of parameters
 * -> chisquared and number of degrees of freedom
 * -> parameter values, errors, and names
 * -> x-axis minimum and maximum
 * NB there is no mechanism to make the correct TF1 from just the stream at present.
 */
class TF1Streamer_v1 : public virtual Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
  
    /**
     * Can't do this because we can't create a TF1 with the correct constructor!
     */
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual unsigned getVersion() const throw() {return s_version;}
    
private:
    TF1Streamer_v1() throw();
    static unsigned s_version;
    static bool inMap;		//True if in IOManager map
};

}
}
#endif // #ifndef SCTDATA_IO_TF1STREAMER_H
