#include "Sct/VersionNotSupportedException.h"
#include "Sct/UnsupportedOperationError.h"
#include "TF1Streamer_v1.h"
#include "../RootStreamableAdapter.h"

#include <TF1.h>
#include <TClass.h>
#include <string>

using namespace Sct;
using namespace std;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TF1Streamer_v1::s_version=1;

	
bool TF1Streamer_v1::inMap = IOManager::addToMap(TF1::Class()->GetName(),  auto_ptr<Streamer>(new TF1Streamer_v1()));

TF1Streamer_v1::TF1Streamer_v1() throw() {}

void TF1Streamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const RootStreamableAdapter& f1is = dynamic_cast<const RootStreamableAdapter&>(ob);
    TF1& f = *(TF1*)f1is.getObject();

    out << f.GetNpar() << f.GetChisquare() << f.GetNDF();
    for (int i=0; i<f.GetNpar(); ++i) {
        out << f.GetParameter(i) << f.GetParError(i) << f.GetParName(i);
    }
    double xmin, xmax;
    f.GetRange(xmin, xmax);
    out << xmin << xmax;
}

void TF1Streamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    RootStreamableAdapter& f1is = dynamic_cast<RootStreamableAdapter&>(ob);
    TF1& f = *(TF1*)f1is.getObject();

    double chisq;
    int npar, ndf;
    in >> npar >> chisq >> ndf;
    //Ignore number of parameters - defined by formula! @todo check it and throw?
    f.SetNDF(ndf);
    f.SetChisquare(chisq);

    for (int i=0; i<f.GetNpar(); ++i) {
        double parameter, error;
        string parname;
        in >> parameter >> error >> parname;
        f.SetParameter(i, parameter);
        f.SetParError(i, error) ;
        f.SetParName(i, parname.c_str());
    }
    double xmin, xmax;
    in >> xmin >> xmax;
    f.SetRange(xmin, xmax);
}

//Can't stream like this as we have no way of creating the right object
shared_ptr<Streamable> TF1Streamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    throw UnsupportedOperationError("TF1IS::refreshGuts has no way of creating creating the right TF1", __FILE__, __LINE__);
}

}
}
