#include "../StrobeDelayTestResult.h"
#include "StrobeDelayTestResultStreamer_v1.h"
#include <vector>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned StrobeDelayTestResultStreamer_v1::s_version=1;
	
StrobeDelayTestResultStreamer_v1::StrobeDelayTestResultStreamer_v1() throw() {
}

bool StrobeDelayTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::StrobeDelayTestResult",  auto_ptr<Streamer>(new StrobeDelayTestResultStreamer_v1()));

shared_ptr<Streamable> StrobeDelayTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new StrobeDelayTestResult());
    read(in, *ad, manager);
    return ad;
}

void StrobeDelayTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");

    const StrobeDelayTestResult& mytest = dynamic_cast<const StrobeDelayTestResult&>(ob);

    out << (double) 0.25;

    unsigned int nopt=mytest.getNOptima();
    out << nopt;
    for (unsigned int i=0; i<nopt; ++i) {
        out << mytest.getOptimum(i);
    }
}

void StrobeDelayTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");

    StrobeDelayTestResult& mytest = dynamic_cast<StrobeDelayTestResult&>(ob);
    double fraction;
    in >> fraction;
    unsigned int nopt;
    in >> nopt;
    mytest.setNOptima(nopt);
    for (unsigned int ichip=0; ichip<nopt; ++ichip) {
        double opt;
        in >> opt ;
        mytest.setOptimum(ichip, opt);
    }
}

}
}
