#ifndef SCTDATA_IO_SCANRESULTSTREAMER_H
#define SCTDATA_IO_SCANRESULTSTREAMER_H

#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

class ISostream;
class ISistream;
class Sct::Streamable;

using namespace std;
using namespace Sct;

namespace SctData {
namespace IO {


/**
This abstract class is an ISSerializer for reading/writing ScanResults to/from IS.
Doesn't implement createObject.
*/
class ScanResultStreamer_v1 : public virtual Streamer {
public:
    virtual unsigned getVersion() const throw() {return s_version;}
protected:
    ScanResultStreamer_v1() throw();			///< Constructor must be protected for sub-classes

    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual shared_ptr<Streamable> read(IStream&, const IOManager&) const throw(LogicError, IoError);
private:
    static unsigned s_version;
    static bool inMap;
};
}
}
#endif //#ifndef SCTDATA_IO_SCANRESULTSTREAMER_H
