#include "ResultHeaderStreamer_v1.h"
#include "../ResultHeader.h"
#include "../ConfigurationVariable.h"
#include "../mVThresholdVariable.h"

#include <string>

using std::string;
using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned ResultHeaderStreamer_v1::s_version=1;
	
ResultHeaderStreamer_v1::ResultHeaderStreamer_v1() throw() {}

bool ResultHeaderStreamer_v1::inMap = IOManager::addToMap("SctData::ResultHeader",  auto_ptr<Streamer>(new ResultHeaderStreamer_v1()));

shared_ptr<Streamable> ResultHeaderStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new ResultHeader(0, 0, "", mVThresholdVariable::instance()));
    read(in, *ad, manager);
    return ad;
}

void ResultHeaderStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Downcast should always work!
    const ResultHeader& header = dynamic_cast<const ResultHeader&>(ob);

    out << header.getRunNumber() << header.getScanNumber() << header.getModuleName();
    out << header.getStartTimeString() << header.getEndTimeString();
    manager.writeImpl(out, header.getVariable(), false);
}

void ResultHeaderStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Downcast should always work!
    ResultHeader& header = dynamic_cast<ResultHeader&>(ob);

    // cout << "ResultHeaderIS refresh" << endl;
    unsigned int runNumber = 0;
    unsigned int scanNumber = 0;
    string name, start, end;
    in >> runNumber >> scanNumber >> name >> start >> end;
    header.setRunNumber(runNumber);
    header.setScanNumber(scanNumber);
    header.setModuleName(name);
    header.setStartTimeString(start);
    header.setEndTimeString(end);
    shared_ptr<Streamable> ob2 = manager.readImpl(in, "SctData::ConfigurationVariable");
    header.setVariable(*boost::dynamic_pointer_cast<ConfigurationVariable>(ob2));	///Should always succeed!

    // cout << "Done" << endl;
}

}
}
