#ifndef SCTDATA_IO_RESPONSECURVESTREAMER_H
#define SCTDATA_IO_RESPONSECURVESTREAMER_H

#include "Sct/Streamable.h"
#include "Sct/Streamer.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
namespace IO {
    
class ResponseCurveStreamer_v1 : public virtual Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual unsigned getVersion() const throw() {return s_version;}

private:
    ResponseCurveStreamer_v1() throw();              ///< Constructor is private
    static unsigned s_version;
    static bool inMap;                      ///< The static dummy variable for the IOManager map
};
} 
}
#endif //#ifndef SCTDATA_IO_RESPONSECURVESTREAMER_H
