#ifndef SCTDATA_IO_RAWSCANRESULTSTREAMER_V2_H
#define SCTDATA_IO_RAWSCANRESULTSTREAMER_V2_H

#include "../RawScanResultIOHelper.h"
#include "ScanResultStreamer_v1.h"

class SctData::RawScanResult;
class TH2D;

using namespace Sct;

namespace SctData {
namespace IO {


/**
This class is an ISSerializer for reading/writing RawScanResults to/from IS.
*/
class RawScanResultStreamer_v3 : public Sct::Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const ;
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const ;
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const ;   
 virtual unsigned getVersion() const throw() {return s_version;}
 
private:
    /**
    Based on the data type, passes control onto the appropriate function for reading out the data
    */
    void readData(IStream& in, RawScanResult& raw) const;

    /**
    Reads in data in Slice format from IS.
    */
    void readSliceData(unsigned int size, unsigned short width, IStream& in, RawScanResult& raw) const;

    /**
    Reads in data in ROOT format from IS.  I.e. same data format as is published by this.
    */
    void readRootData(unsigned int size, unsigned short width, IStream& in, RawScanResult& raw) const;
    
    /**
    Reads in data in Raw format from IS.
    */
    void readRawData(unsigned int size, unsigned short width, IStream& in, RawScanResult& raw) const;

    void setHistSize(RawScanResult& raw, unsigned nbinsx, short unsigned ilink) const;

    /** 
	creates an occupancy histogram with correct name etc for module 
	in the right place on the RawData
     */
    static void createOccupancyHistogram(const RawScanResultIOHelper& helper, const RawScanResult& raw, unsigned ichip);
    
    /** utility function works out where the occ data is for a particular chip, bin, scanpoint */
    static unsigned getOccWordPosition(unsigned ichip, unsigned ibin, unsigned ipt);

    //Data
    mutable RawScanResultIOHelper helper;		///< The IOHelper
    RawScanResultStreamer_v3() throw();			///< Constructor is private
     static unsigned s_version;
     static bool inMap;					///< The static dummy variable for the IOManager map
};

}
}
#endif //#ifndef SCTDATA_IO_RAWSCANRESULTSTREAMER_V2_H
