#ifndef SCTDATA_IO_NOISEOCCUPANCYTESTRESULTSTREAMER_H
#define SCTDATA_IO_NOISEOCCUPANCYTESTRESULTSTREAMER_H

#include "TestResultStreamer_v1.h"
class SctData::ChipNOResult;
using SctData::ChipNOResult;

namespace SctData {
namespace IO {

/**
 * This class allows publishing and refreshing of NoiseOccupancyTestResult objects to and from IS.
 * The published and refresehd elements are:
 * The (usually 12) noise occupancy graphs.
 * The (usually 12) noise occupancy fits.
 */
class NoiseOccupancyTestResultStreamer_v1 : public Sct::Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    void writeChipResult(OStream& out, const ChipNOResult&, const IOManager& manager) const throw(LogicError, IoError) ;
    void readChipResult(IStream& in, ChipNOResult&, const IOManager& manager) const throw(LogicError, IoError) ;
    virtual unsigned getVersion() const throw() {return s_version;}    
private:
    NoiseOccupancyTestResultStreamer_v1() throw();
    static unsigned s_version;
    static bool inMap;
};
} 
}
#endif // #ifndef SCTDATA_IO_NOISEOCCUPANCYTESTRESULTSTREAMER_H
