#ifndef SCTDATA_IO_NPTGAINTESTRESULTSTREAMER_H
#define SCTDATA_IO_NPTGAINTESTRESULTSTREAMER_H

#include "Sct/Streamer.h"

namespace SctData {
class NPtGainTestResult;
class NPtGainTestResultData;
}

using namespace SctData;

namespace SctData {
namespace IO {


/**
 * This class allows publishing and refreshing of NPtGainTestResult objects to and from IS.
 * The published and refreshed elements are:
 * 
 */
class NPtGainTestResultStreamer_v1 : public Sct::Streamer {
public:
    //Streamer overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual unsigned getVersion() const throw() {return s_version;}

private:
    void writeData(OStream& out, const NPtGainTestResultData& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);
    void readData(IStream& in, NPtGainTestResult& mytest, NPtGainTestResultData& ob, const IOManager& manager) const throw(Sct::LogicError, Sct::IoError);

    NPtGainTestResultStreamer_v1() throw();	///< Constructor is private
    static unsigned s_version;
    static bool inMap;				///< The static dummy variable for the IOManager map
};
}
}
#endif // #ifndef SCTDATA_IO_NPTGAINTESTRESULTSTREAMER_H
