#include "../NPtGainTestResult.h"
#include "../RootStreamableAdapter.h"
#include "../ResponseCurve.h"
#include "NPtGainTestResultStreamer_v1.h"

#include <TF1.h>
#include <vector>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned NPtGainTestResultStreamer_v1::s_version=1;


  NPtGainTestResultStreamer_v1::NPtGainTestResultStreamer_v1() throw() {}

bool NPtGainTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::NPtGainTestResult",  auto_ptr<Streamer>(new NPtGainTestResultStreamer_v1()));


shared_ptr<Streamable> NPtGainTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new NPtGainTestResult());
    read(in, *ad, manager);
    return ad;
}

void NPtGainTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //cout << "NPtGainTestResultIS::publishGuts" << endl;
    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");

    const NPtGainTestResult& mytest = dynamic_cast <const NPtGainTestResult&>(ob);

    out << mytest.getNChipData();
    for (unsigned int i = 0; i < mytest.getNChipData(); ++i) {
        writeData(out, mytest.getChipData(i), manager);
    }

    out << mytest.getNChannelData();
    for (unsigned int i = 0; i < mytest.getNChannelData(); ++i) {
        writeData(out, mytest.getChannelData(i), manager);
    }
}

void NPtGainTestResultStreamer_v1::writeData(OStream& out, const NPtGainTestResultData& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.writeImpl(out, *ob.rc, false);
    manager.writeImpl(out, RootStreamableAdapter(*ob.graph), false);
    out << ob.gain << ob.noise << ob.offset;
}

void NPtGainTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");

    NPtGainTestResult& mytest = dynamic_cast < NPtGainTestResult & >(ob);

    unsigned int n = 0;
    in >> n;
    mytest.setChipDataSize(n);

    for (unsigned int i = 0; i<n; ++i) {
        readData(in, mytest, mytest.getChipData(i), manager);
    }

    in >> n;
    mytest.setChannelDataSize(n);
    for (unsigned int i = 0; i<n; ++i) {
        readData(in, mytest, mytest.getChannelData(i), manager);
    }
}

void NPtGainTestResultStreamer_v1::readData(IStream& in, NPtGainTestResult& mytest, NPtGainTestResultData& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Response Curve
    shared_ptr<Streamable> str = manager.readImpl(in, "SctData::ResponseCurve");
    shared_ptr<ResponseCurve> rc = boost::dynamic_pointer_cast<ResponseCurve>(str) ;
    ob.rc = rc;

    //TGraph
    ob.graph = shared_ptr<TGraph>(new TGraph());
    RootStreamableAdapter ad2(*ob.graph);
    manager.readImpl(in, ad2, false);

    //Rest
    in >> ob.gain >> ob.noise >> ob.offset;
}
}


} 

