#include "ModuleConfigurationStreamer_v2.h"
#include "../ModuleConfiguration.h"
#include <CommonWithDsp/sctStructure.h>

namespace SctData {
namespace IO {

unsigned ModuleConfigurationStreamer_v2::s_version=2;
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

ModuleConfigurationStreamer_v2::ModuleConfigurationStreamer_v2() throw() {}
	
bool ModuleConfigurationStreamer_v2::inMap = IOManager::addToMap("SctData::ModuleConfiguration",  std::auto_ptr<Streamer>(new ModuleConfigurationStreamer_v2()));


shared_ptr<Streamable> ModuleConfigurationStreamer_v2::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> m (new ModuleConfiguration());
    read(in, *m, manager);
    return m;
}

void ModuleConfigurationStreamer_v2::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const ModuleConfiguration& config = dynamic_cast<const ModuleConfiguration&>(ob);
    const ABCDModule& data = config.getABCDModule();
    
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
      manager.writeImpl(out, config.getChipConfiguration(i), false);
    }
    out << data.present << data.active << data.select << data.groupId << data.pTTC << data.rTTC;
    out.put(data.rx, 2);  
}

void ModuleConfigurationStreamer_v2::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    ModuleConfiguration& config = dynamic_cast<ModuleConfiguration&>(ob);
    ABCDModule& data = config.getABCDModule();
    
    for (unsigned int i=0; i<Sct::nChipModule; ++i) {
      manager.readImpl(in, config.getChipConfiguration(i), false);
    }
    in >> data.present >> data.active >> data.select >> data.groupId >> data.pTTC >> data.rTTC;
    in.get(data.rx, 2);
}


}
}
