#include "FullBypassTestResultStreamer_v1.h"

using namespace Sct;

namespace SctData {
namespace IO {

unsigned FullBypassTestResultStreamer_v1::s_version=1;
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE*/

FullBypassTestResultStreamer_v1::FullBypassTestResultStreamer_v1() throw() {}

bool FullBypassTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::FullBypassTestResult",  auto_ptr<Streamer>(new FullBypassTestResultStreamer_v1()));

shared_ptr<Streamable> FullBypassTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError){
    boost::shared_ptr<Streamable> ad (new FullBypassTestResult());
    read(in, *ad, manager);
    return ad;
}

void FullBypassTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {

    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");
    
    const FullBypassTestResult& mytest = dynamic_cast<const FullBypassTestResult&>(ob);

    out << mytest.getVddNom() << mytest.getNConfig();

    for (unsigned int ichip=0; ichip<nChipModule; ichip++) {
        writeChipResult(out, mytest.getChipResult(ichip), manager);
    }
}

void FullBypassTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");
    
    FullBypassTestResult& mytest = dynamic_cast<FullBypassTestResult&>(ob);

    float myfloat; unsigned myunsigned;
    in >> myfloat; mytest.setVddNom(myfloat);
    in >> myunsigned; mytest.setNConfig(myunsigned);

    for (unsigned int ichip=0; ichip<nChipModule; ichip++) {
        readChipResult(in, mytest.getChipResult(ichip), manager);
    }
}
    
void FullBypassTestResultStreamer_v1::writeChipResult(OStream& out, const FullBypassTestResult::ChipFBResult& c, const IOManager& manager) const throw (LogicError, IoError) {
    out << c.status_direct << c.vdd_direct << c.status_bypass << c.vdd_bypass;
}

void FullBypassTestResultStreamer_v1::readChipResult(IStream& in, FullBypassTestResult::ChipFBResult& c, const IOManager& manager) const throw(LogicError, IoError) {
    in >> c.status_direct >> c.vdd_direct >> c.status_bypass >> c.vdd_bypass;
}

} 
}
