#ifndef SCTDATA_IO_FITSCANRESULTSTREAMER_V1_H
#define SCTDATA_IO_FITSCANRESULTSTREAMER_V1_H

#include "ScanResultStreamer_v1.h"
#include "../FitScanResultIOHelper.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

namespace SctData {
namespace IO {

/**
This class is an Streamer for reading/writing FitScanResults.
*/
class FitScanResultStreamer_v1 : public Sct::Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual unsigned getVersion() const throw() {return s_version;}
private:
    FitScanResultIOHelper helper;			///< The IOHelper
    FitScanResultStreamer_v1() throw() ;		///< Private constructor
    static unsigned s_version;
    static bool inMap;				///< The static dummy variable for the IOManager map

};
}
}
#endif //#ifndef SCTDATA_IO_FITSCANRESULTSTREAMER_V1_H
