#include "FitScanResultStreamer_v1.h"
#include "../FitScanResult.h"
#include "../FitObject.h"
#include "Sct/VersionNotSupportedException.h"

using namespace Sct;
using namespace boost;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned FitScanResultStreamer_v1::s_version=1;

FitScanResultStreamer_v1::FitScanResultStreamer_v1() throw() {}

bool FitScanResultStreamer_v1::inMap = IOManager::addToMap("SctData::FitScanResult",  auto_ptr<Streamer>(new FitScanResultStreamer_v1()));


shared_ptr<Streamable> FitScanResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (&helper.create());
    read(in, *ad, manager);
    return ad;
}

void FitScanResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Let superclass do its worker
  manager.writeImpl(out, ob, "SctData::ScanResult");
    
    //Downcast should always work!
    const FitScanResult& fit = dynamic_cast<const FitScanResult&>(ob);
    
    unsigned int n = 0;
    string className;
    
    n = fit.getNLinkFits();
    out << n;
    ///@todo modify when bug is fixed in IS
    if (n>0) manager.writeClassName(out, fit.getLinkFit(0).getClassName());
    for (unsigned i=0; i<n; i++) {
        FitObject& fo = fit.getLinkFit(i);
        manager.writeImpl(out, fo, false);
    }
    
    n = fit.getNChipFits();
    out << n;
    if (n>0) manager.writeClassName(out, fit.getChipFit(0).getClassName());
    for (unsigned i=0; i<n; i++) {
        FitObject& fo = fit.getChipFit(i);
        manager.writeImpl(out, fo, false);
    }
    
    n = fit.getNChannelFits();
    out << n;
    if (n>0) manager.writeClassName(out, fit.getChannelFit(0).getClassName());
    for (unsigned i=0; i<fit.getNChannelFits(); i++) {
        FitObject& fo = fit.getChannelFit(i);
        manager.writeImpl(out, fo, false);
    }
    
    manager.writeImpl(out, fit.getDefects(), false);
}


void FitScanResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
  manager.readImpl(in, ob, "SctData::ScanResult");

    FitScanResult& fit = dynamic_cast<FitScanResult&>(ob);
    
    unsigned size;
    
    in >> size;    
    string className; 
    fit.setNLinkFits(size);
    if (size > 0) {
        className = manager.readClassName(in);
    }
    for (unsigned i=0; i<size ; i++) {
        shared_ptr<FitObject> fo (dynamic_pointer_cast<FitObject>(manager.readImpl(in, className)));
	fit.setLinkFit(i, fo);
    }
    
    in >> size;    
    fit.setNChipFits(size);
    if (size > 0) {
         className= manager.readClassName(in);
    }
    for (unsigned i=0; i<size ; i++) {
        shared_ptr<FitObject> fo (dynamic_pointer_cast<FitObject>(manager.readImpl(in, className)));
	fit.setChipFit(i, fo);
    }
    
    in >> size;    
    fit.setNChannelFits(size);
    if (size > 0) {
	className = manager.readClassName(in);
    }
    for (unsigned i=0; i<size ; i++) {
        shared_ptr<FitObject> fo (dynamic_pointer_cast<FitObject>(manager.readImpl(in, className)));
	fit.setChannelFit(i, fo);
    }
    manager.readImpl(in, fit.getDefects(), false);
}

}
}
