#include "DcsDataStreamer_v1.h"
#include "../DcsData.h"
#include "Sct/IOManager.h"
#include "Sct/IStream.h"
#include "Sct/OStream.h"
#include "boost/shared_ptr.hpp"

using namespace Sct;

namespace SctData {
namespace IO {

unsigned DcsDataStreamer_v1::s_version=1;
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

DcsDataStreamer_v1::DcsDataStreamer_v1() throw() {}
	
bool DcsDataStreamer_v1::inMap = IOManager::addToMap("SctData::DcsData",  std::auto_ptr<Streamer>(new DcsDataStreamer_v1()));


shared_ptr<Streamable> DcsDataStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
  boost::shared_ptr<Streamable> m (new DcsData());
  read(in, *m, manager);
  return m;
}

void DcsDataStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const DcsData& data = dynamic_cast<const DcsData&>(ob);

    out << data.getVbias() << data.getIbias() 
	<< data.getT0() << data.getT1()
	<< data.getVcc() << data.getIcc()
	<< data.getVdd() << data.getIdd();
}

void DcsDataStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    DcsData& data = dynamic_cast<DcsData&>(ob);

    float temp = 0;
    in >> temp; data.setVbias(temp);
    in >> temp; data.setIbias(temp);
    in >> temp; data.setT0(temp);
    in >> temp; data.setT1(temp);
    in >> temp; data.setVcc(temp);
    in >> temp; data.setIcc(temp);
    in >> temp; data.setVdd(temp);
    in >> temp; data.setIdd(temp);
}

}
}
