#ifndef SCTDATA_IO_CONFIGURATIONVARIABLESTREAMER_H
#define SCTDATA_IO_CONFIGURATIONVARIABLESTREAMER_H

#include "Sct/Streamable.h"
#include "Sct/Streamer.h"
#include "Sct/Exception.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

using namespace Sct;

namespace SctData {
namespace IO {
 
class ConfigurationVariableStreamer_v1 : public virtual Streamer {
public:
    //Streamer overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual unsigned getVersion() const throw() {return s_version;}    
private:
    ConfigurationVariableStreamer_v1() throw();
    static unsigned s_version;
    static bool inMap;
};
    
}
}

#endif //SCTDATA_IO_CONFIGURATIONVARIABLESTREAMER_H
