#include "ChipConfigurationStreamer_v1.h"
#include "../ChipConfiguration.h"
#include "Sct/LogicErrors.h"
#include <CommonWithDsp/sctStructure.h>

namespace SctData {
namespace IO {

unsigned ChipConfigurationStreamer_v1::s_version=1;
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */

ChipConfigurationStreamer_v1::ChipConfigurationStreamer_v1() throw() {}
	
bool ChipConfigurationStreamer_v1::inMap = IOManager::addToMap("SctData::ChipConfiguration",  std::auto_ptr<Streamer>(new ChipConfigurationStreamer_v1()));


shared_ptr<Streamable> ChipConfigurationStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
  throw Sct::IllegalStateError("Can't create a ChipConfiguration from scratch, since constructor requires ABCDChip reference.", __FILE__, __LINE__);
  //    shared_ptr<Streamable> m (new ChipConfiguration());
  //  read(in, *m, manager);
  //  return m;
}

void ChipConfigurationStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    const ChipConfiguration& config = dynamic_cast<const ChipConfiguration&>(ob);
    const ABCDChip& data=config.getConfig();
    out << data.active << data.address << data.target;

    //Config values
    out << (UINT16)data.basic.config.readoutMode << (UINT16)data.basic.config.calibMode << (UINT16)data.basic.config.trimRange;
    out << (UINT16)data.basic.config.edgeDetect << (UINT16)data.basic.config.mask << (UINT16)data.basic.config.accumulate;
    out << (UINT16)data.basic.config.inputBypass << (UINT16)data.basic.config.outputBypass << (UINT16)data.basic.config.master;
    out << (UINT16)data.basic.config.end << (UINT16)data.basic.config.feedThrough;
    
    out << data.basic.vthr << data.basic.vcal << data.basic.delay << data.basic.preamp << data.basic.shaper;
    out.put(data.basic.mask, 4);
    
    //ABCDCalData
    out << data.caldata.rc_function;
    out.put(data.caldata.rc_params, 3);
    out << data.caldata.c_factor;
    out.put(data.trim, Sct::nChannelChip);    
}

void ChipConfigurationStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    ChipConfiguration& config = dynamic_cast<ChipConfiguration&>(ob);
    ABCDChip& data=config.getConfig();

    in >> data.active >> data.address >> data.target;
    
    //ABCDBasic stuff:
    
    //Config values    
    UINT16 temp = 0;
    in >> temp;
    data.basic.config.readoutMode = temp;
    in >> temp;
    data.basic.config.calibMode = temp;
    in >> temp;
    data.basic.config.trimRange = temp;
    in >> temp;
    data.basic.config.edgeDetect = temp;
    in >> temp;
    data.basic.config.mask = temp;
    in >> temp;
    data.basic.config.accumulate = temp;
    in >> temp;
    data.basic.config.inputBypass = temp;
    in >> temp;
    data.basic.config.outputBypass = temp;
    in >> temp;
    data.basic.config.master = temp;
    in >> temp;
    data.basic.config.end = temp;
    in >> temp;
    data.basic.config.feedThrough = temp;
    
    in >> data.basic.vthr >> data.basic.vcal >> data.basic.delay >> data.basic.preamp >> data.basic.shaper;
    in.get(data.basic.mask, 4);
    
    //ABCDCalData
    in >> data.caldata.rc_function;
    //cout << "rc_function: " << (int)data.caldata.rc_function << endl;
    in.get(data.caldata.rc_params, 3);
    in >> data.caldata.c_factor;
    
    in.get(data.trim, Sct::nChannelChip);    
}

}
}
