#ifndef GAUSFITOBJECT_H
#define GAUSFITOBJECT_H

#include "FitObject.h"

using namespace Sct;

namespace SctData{

/** 
 * A derrived class of the FitObject class of gausian form
 * f = [0] * exp( 0.5 * ( (x-[1])/[2] )**2 )
 * Parameters: [0] is the prefactor;
 *             [1] is the mean;
 *             [2] is the standard deviation;
 * @author Alan Barr
 * @date 9 December 2002
 */

class GausFitObject : public FitObject {
public:
    /// Default constructor
    GausFitObject();

    /// Constructor from ROOT TF1;
    GausFitObject(const TF1& rootfunc);
    
    virtual shared_ptr<FitObject> clone() const throw();

    /// Destructor
    virtual ~GausFitObject() throw() {;}
    
    virtual string getClassName() const throw() {return "SctData::GausFitObject";}
    
    /// Checks for formula of TF1="gaus" before continuing;
    GausFitObject& operator= (const TF1& ) throw(LogicError) ;
	  
protected:
    /// make a ROOT TF1 with the appropriate constructor
    auto_ptr<TF1> makeBasicRootTF1() const throw(LogicError);
    
private:
    static vector<string> createParNames();
    static vector<string> parNames;    
};

} // end of namespace SctData
#endif // #ifndef GAUSFITOBJECT_H
