#include "GausFitObject.h"
#include "Sct/LogicErrors.h"

#include <TF1.h>

// Over-ride function...
// Calls base-class equality operator then renames the parameters

namespace SctData {

/**
  file static method to create vector of parameter names
  */
vector<string> GausFitObject::createParNames() {
    vector<string> parNames(3);
    parNames[0] = "Prefact";
    parNames[1] = "Mean";
    parNames[2] = "Sigma";
    return parNames;
}

vector<string> GausFitObject::parNames = createParNames();
    
GausFitObject::GausFitObject() : FitObject("gaus", 3, parNames) {
}

GausFitObject::GausFitObject(const TF1& f) : FitObject("gaus", 3, parNames, f){
}

shared_ptr<FitObject> GausFitObject::clone() const throw() {
    return shared_ptr<FitObject> (new GausFitObject(*this));
}

GausFitObject& GausFitObject::operator= (const TF1& rootfunc) throw(LogicError) {
    //      if (!strcmp(rootfunc.GetName(), "gaus")) {
    //	  ostringstream os; os <<"GausFitObject::operator=(TF1&) not a gaus TF1: "
    //			       <<rootfunc.GetName();
    //	  throw InvalidArgument(os.str());
    //      }
    this->FitObject::operator=(rootfunc);
    return (*this);
}

auto_ptr<TF1> GausFitObject::makeBasicRootTF1() const throw(LogicError) {
    auto_ptr<TF1> r ( new TF1("mygaus","gaus"));
    if (!r.get())
        throw InvariantViolatedError("GausFitObject::makeBasicRootTF1()", __FILE__, __LINE__);
    return r;
}


} // end of namespace SctData
