#include "FullBypassTestResult.h"
#include "NullVariable.h"
#include "DefaultVariable.h"
#include <CommonWithDsp/ABCD/ABCDscans.h>

namespace SctData{
    FullBypassTestResult::FullBypassTestResult() throw() : chipResults("FullBypassChipResult") {
	chipResults.resize(nChipModule);
    }
    
    FullBypassTestResult::FullBypassTestResult(unsigned int runNumber, const string& moduleName) throw()
	: TestResult(runNumber, moduleName, NullVariable::instance(), 
		     *DefaultVariable::instance(ST_COMPRESSION)), chipResults("FullBypassChipResult")
    {}
    
    FullBypassTestResult::~FullBypassTestResult() throw() {}

    string FullBypassTestResult::getClassName() const throw(){
	return string("SctData::FullBypassTestResult");
    }

    const FullBypassTestResult::ChipFBResult& FullBypassTestResult::getChipResult(const unsigned index) const{
	return chipResults[index];
    }
    
    FullBypassTestResult::ChipFBResult& FullBypassTestResult::getChipResult(const unsigned index){
	return chipResults[index];
    }
}
