#include "Rtypes.h"
namespace SctData{
  /**@name Fit Functions
   * declaration of functions used by ROOT TF1
   * for evaluating our FitObject subclasses.
   * @{
   */
	
/**
Calculate the parameterized erf funtion.
*/
Double_t erf(Double_t *x, Double_t *par) throw();

/**
Calculate the parameterized erfc funtion.
*/
Double_t erfc(Double_t *x, Double_t *par) throw();
	
/**
Calculate the smeared tophat function.  I.e. paramterized erf*erfc
*/
Double_t tophat(Double_t *x, Double_t *par) throw();

	///@}
} // end of namespace SctData
