#ifndef ERFCFITOBJECT_H
#define ERFCFITOBJECT_H

#include "FitObject.h"


namespace SctData{

/** 
 * A derived class of the FitObject class of complimentary error function
 * <P>
 * parameters: prefactor, mean, sigma. </P>
 * Evaluation uses TMath function Erf(x) = (2/sqrt(pi)) Integral(exp(-t^2))dt between 0 and x
 * @author Alan Barr
 * @date 9 December 2002
 */

class ErfcFitObject : public FitObject {
public:
    /**
      Prefered way to create an ErfcFitObject.  May use more efficient allocation
      stuff than the default constructor.
      @note Nothrow
      */
    static shared_ptr<ErfcFitObject> create();
    
    /// Constructor 
    ErfcFitObject();
    
    /// Constructor from a root TF1;.
    ErfcFitObject(const TF1& rootfunc);

    virtual string getClassName() const throw() {return "SctData::ErfcFitObject";}
    
    virtual shared_ptr<FitObject> clone() const throw();

    /// Destructor does nothing
    virtual ~ErfcFitObject() throw() {;}
	  
    /// equality with root TF1
    ErfcFitObject& operator=(const TF1& rootfunc) throw(LogicError);
	  
protected:
    /// call the correct constructor for making a ROOT TF1
    auto_ptr<TF1> makeBasicRootTF1() const throw(LogicError);
    
private:
    static vector<string> createParNames();
    static vector<string> parNames;
}; // end of definition of class ErfcFitObject
    
}// end of namespace SctData
#endif // #ifndef ERFCFITOBJECT_H
