#include "ErfcFitObject.h"
#include "FitFunctions.h"
#include "ObjectPool.h"

#include <TMath.h>
#include <TF1.h>

using namespace Sct;

namespace SctData {
    
/**
  static method to create vector of parameter names
  */
vector<string> ErfcFitObject::createParNames() {
    vector<string> parNames(3);
    parNames[0] = "Prefact";
    parNames[1] = "Mean";
    parNames[2] = "Sigma";
    return parNames;
}

vector<string> ErfcFitObject::parNames = ErfcFitObject::createParNames();    

shared_ptr<ErfcFitObject> ErfcFitObject::create() {
    static ObjectPool<ErfcFitObject> pool;
    return pool.get();
}

ErfcFitObject::ErfcFitObject() : FitObject("erfc", 3, parNames) {
    //cout << "ErfcFitObject created: " << this << endl;
}

shared_ptr<FitObject> ErfcFitObject::clone() const throw() {
    return create();
    //return shared_ptr<FitObject> (new ErfcFitObject(*this));
}

ErfcFitObject& ErfcFitObject::operator=(const TF1& f)throw(LogicError)  {
    this->FitObject::operator=(f);
    return *this;
}

ErfcFitObject::ErfcFitObject(const TF1& f) : FitObject("erfc", 3, parNames, f) {
}


// Call the appropriate constructor for making a ROOT TF1 object from this ErfFitObject
auto_ptr<TF1> ErfcFitObject::makeBasicRootTF1() const throw(LogicError) {
    auto_ptr<TF1> r( new TF1(0, SctData::erfc, this->getVarMin(0), this->getVarMax(0), 3));
    if (!r.get())
        throw InvariantViolatedError("ErfcFitObject::makeBasicRootTF1()", __FILE__, __LINE__);
    return r;
}

} // end of namespace SctData

