#ifndef CALCHARGEVARIABLE_H
#define CALCHARGEVARIABLE_H

#include "ConfigurationVariable.h"
#include "ModuleConfiguration.h"

namespace SctData {
    
class CalChargeVariable : public ConfigurationVariable {
public:
    virtual double getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual void setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw(); 
protected:
    CalChargeVariable(unsigned int typeRep, std::string strategyDescription);
};


inline CalChargeVariable::CalChargeVariable(unsigned int typeRep, std::string strategyDescription) : ConfigurationVariable(typeRep, "CalCharge", strategyDescription) {}

inline double CalChargeVariable::getChipActualPoint(const ModuleConfiguration& config, unsigned int chip) const throw() {
    return config.getChipConfiguration(chip).getCalCharge();
}

///@todo Check parameters here?
inline void CalChargeVariable::setChipActualPoint(double actualPt, ModuleConfiguration& config, unsigned int chip) const throw() {
    config.getChipConfiguration(chip).setCalCharge((unsigned char) actualPt);
}


}

#endif //#ifndef CALCHARGEVARIABLE_H
