/* Generated by Together */

package SctData;

/**
 * This class contains the identifying information about a scan result.
 * It is entirely defined by a run number, a scan number, a module name and a scan variable.
 * The combination of the first 3 of those should be guarenteed to be unique.
 * @author Matthew Palmer
 */
public class ResultHeader implements Sct.Serializable {
    public ResultHeader(int runNumber, int scanNumber, String moduleName, ConfigurationVariable variable,
			String startTime, String endTime) {
        this.scanNumber = scanNumber;
        this.runNumber = runNumber;
        this.moduleName = moduleName;
        this.variable = variable;
	this.startTime = startTime;
	this.endTime = endTime;
    }
    
    public String getClassName() {
        return "SctData.ResultHeader";
    }

    public String getUniqueID() {
        return getUniqueID(runNumber, scanNumber, moduleName);
    }

    public static String getUniqueID(int runNumber, int scanNumber, String moduleName) {
        return runNumber + "." + scanNumber + "." + moduleName;
    }

    public long getScanNumber() {
        return scanNumber;
    }

    public long getRunNumber() {
        return runNumber;
    }

    public String getModuleName() {
        return moduleName;
    }

    public ConfigurationVariable getVariable() {
        return variable;
    }
    
    public String getStartTimeString() {
	return startTime;
    }
    
    public String getEndTimeString() {
	return endTime;
    }

    public boolean equals(Object s) {
        if (!(s instanceof ResultHeader)) return false;
        ResultHeader sh2 = (ResultHeader)s;
        if (this.scanNumber == sh2.scanNumber && this.runNumber == sh2.runNumber 
            && this.moduleName.equals(sh2.moduleName)) return true;
        return false;
    }
    
    public static ResultHeader read(Sct.IStream s, Sct.ObjectManager o) throws java.io.IOException {
        int runNumber = s.readInt("RunNumber");
        int scanNumber = s.readInt("ScanNumber");
        String moduleName = s.readString("ModuleName");
	String startTime = s.readString("StartTime");
	String endTime = s.readString("EndTime");
        ConfigurationVariable variable = (ConfigurationVariable)o.readObject(s, "ScanVariable", "SctData.ConfigurationVariable");
        return new ResultHeader(runNumber, scanNumber, moduleName, variable, startTime, endTime);
    }
    
    public void write(Sct.OStream s, Sct.ObjectManager o) throws java.io.IOException {
        s.writeInt("RunNumber", runNumber, false);
        s.writeInt("ScanNumber", scanNumber, false);
        s.writeString("ModuleName", moduleName);
	s.writeString("StartTime", startTime);
	s.writeString("EndTime", endTime);
        o.writeObject(s, "ScanVariable", variable, false);
    }
    
    private int scanNumber;
    private int runNumber;
    private String moduleName;
    private ConfigurationVariable variable;
    private String startTime;
    private String endTime;
}
