/*
 * ChipOptions.java
 *
 * Created on 10 November 2003, 16:59
 */

package SctData;

import sctConf.*;

/**
 * Represents the options in the bitfield ABCDConfig
 * @author  Matthew Palmer
 */
public class ChipOptions implements Sct.Streamable {
    
    /** Creates a new instance of ChipOptions */
    public ChipOptions(ABCDConfig data) {
        this.data = data;
    }
    
    public String getClassName() {
        return "SctData.ChipOptions";
    }   
    
    public ABCDConfig getData() {
        return data;
    }
    
    public byte getReadOutMode() {
        return getDoubleBit(0);
    }
    
    public void setReadOutMode(byte readOut) {
        if (readOut > 3) throw new IllegalArgumentException("Readout mode must be below 4.  Given: " + readOut);
        setDoubleBit(readOut, 0);
    }
    
    public byte getCalibMode() {
        return getDoubleBit(2);
    }
    
    public void setCalibMode(byte calib) {
        if (calib > 3) throw new IllegalArgumentException("Cali mode must be below 4.  Given: " + calib);
        setDoubleBit(calib, 2);
    }

    public byte getTrimRange() {
        return getDoubleBit(4);
    }
    
    public void setTrimRange(byte trimRange) {
        if (trimRange > 3) throw new IllegalArgumentException("Trim Range must be below 4.  Given: " + trimRange);
        setDoubleBit(trimRange, 4);
    }

    
    public boolean getEdgeDetect() {
        return getBit(6);
    }
    
    public void setEdgeDetect(boolean edge) {
        setBit(edge, 6);      
    }
    
    public boolean getMaskFlag() {
        return getBit(7);
    }
    
    public void setMaskFlag(boolean mask) {
        setBit(mask, 7);           
    }

    public boolean getAccumulate() {
        return getBit(8);
    }
    
    public void setAccumulate(boolean mask) {
        setBit(mask, 8);           
    }
    
    public boolean getInputBypass() {
        return getBit(9);
    }
    
    public void setInputBypass(boolean mask) {
        setBit(mask, 9);           
    }

    public boolean getOutputBypass() {
        return getBit(10);
    }
    
    public void setOutputBypass(boolean mask) {
        setBit(mask, 10);           
    }

    public boolean getMaster() {
        return getBit(11);
    }
    
    public void setMaster(boolean mask) {
        setBit(mask, 11);           
    }

    public boolean getEnd() {
        return getBit(12);
    }
    
    public void setEnd(boolean mask) {
        setBit(mask, 12);           
    }

    public boolean getFeedThrough() {
        return getBit(13);
    }
    
    public void setFeedThrough(boolean mask) {
        setBit(mask, 13);           
    }

    
    public static Sct.Streamable read(Sct.IStream s, Sct.ObjectManager o) throws java.io.IOException {
        ChipOptions co = new ChipOptions(new ABCDConfig());
        co.readObject(s, o);
        return co;
    }
    
    public void readObject(Sct.IStream s, Sct.ObjectManager o) throws java.io.IOException {
        setReadOutMode((byte)s.readShort("ReadoutMode"));
        setCalibMode((byte)s.readShort("CalibMode"));
        setTrimRange((byte)s.readShort("TrimRange"));
        
        setEdgeDetect(s.readShort("EdgeDetect") == 0 ? false : true);
        setMaskFlag (s.readShort("SendMask") == 0 ? false : true);
        setAccumulate(s.readShort("Accumulate") == 0 ? false : true);
        setInputBypass(s.readShort("InputBypass") == 0 ? false : true);
        setOutputBypass(s.readShort("OutputBypass") == 0 ? false : true);
        setMaster(s.readShort("Master") == 0 ? false : true);
        setEnd(s.readShort("End") == 0 ? false : true);
        setFeedThrough(s.readShort("FeedThrough") == 0 ? false : true);
    }
    
    public void write(Sct.OStream s, Sct.ObjectManager o) throws java.io.IOException {
        s.writeShort("ReadoutMode", getReadOutMode(), false);
        s.writeShort("CalibMode", getCalibMode(), false);
        s.writeShort("TrimRange", getTrimRange(), false);
                        
        s.writeShort("EdgeDetect", getEdgeDetect()?(short)1 :(short)0, false);
        s.writeShort("SendMask", getMaskFlag()?(short)1 :(short)0, false);        
        s.writeShort("Accumulate", getAccumulate()?(short)1 :(short)0, false);
        s.writeShort("InputBypass", getInputBypass()?(short)1 :(short)0, false);
        s.writeShort("OutputBypass", getOutputBypass()?(short)1 :(short)0, false);
        s.writeShort("Master", getMaster()?(short)1 :(short)0, false);
        s.writeShort("End", getEnd()?(short)1 :(short)0, false);
        s.writeShort("FeedThrough", getFeedThrough()?(short)1 :(short)0, false);
    }
    
    private void setDoubleBit(byte set, int startBit) {
        data.bitField = (short)((data.bitField & ~(3<<startBit)) | (set << startBit));
    }
    
    private byte getDoubleBit(int startBit) {
        return (byte)((data.bitField >> startBit) & 3);
    }
    
    private void setBit(boolean set, int bit) {
        if (set) 
            data.bitField |= 1<<bit;
        else
            data.bitField &= ~(1<<bit);    
    }
    
    private boolean getBit(int bit) {
        return ((data.bitField & (1<<bit)) == (1<<bit));
    }
    
    private ABCDConfig data;
}
