#include <boost/date_time/posix_time/posix_time.hpp>
#include "ResultHeader_Test.h"
#include "../src/ResultHeader.h"
#include <boost/test/unit_test.hpp>


using boost::unit_test_framework::test_suite;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace Sct;

namespace SctData{
  
    void testDates() {
	ResultHeader r;
	ptime t(date(2004, 1, 20), time_duration(1,0,0,9));
	r.setStartTime(t);

	ptime t2(date(2001, 5, 27), time_duration(1,0,0,9));
	r.setEndTime(t2);

	BOOST_CHECK(r.getStartTime() == ptime(date(2004, 1, 20), time_duration(1,0,0,0)));
	BOOST_CHECK(r.getEndTime() == ptime(date(2001, 5, 27), time_duration(1,0,0,0)));
    }

    ResultHeader_Test::ResultHeader_Test() {
	add(BOOST_TEST_CASE(&testDates));
    }	
}
