#include "ObjectPool_Test.h"
#include "../src/ObjectPool.h"
#include <boost/test/unit_test.hpp>
#include <list>
#include <iostream>

using boost::unit_test_framework::test_suite;
using namespace boost;
using namespace std;

namespace SctData{
  
class Object {
public:
    Object() {
	++creationCount;
	//cout << "Object created: " << this << "  total created: " << creationCount << endl;
    }
	
    ~Object() {
	++deletionCount;
	//cout << "Object deleted: " << this << "  total deleted: " << deletionCount << endl;
    }
    
    void reset() {
	++resetCount;
	//cout << "Object reset: " << this << "  total reset: " << resetCount << endl;
    }
    
    static unsigned int creationCount;
    static unsigned int deletionCount;
    static unsigned int resetCount;
};
    
unsigned int Object::creationCount = 0;
unsigned int Object::deletionCount = 0;
unsigned int Object::resetCount = 0;

#define NCREATE 10    

void testPool() {
    ObjectPool<Object> pool;
    list<shared_ptr<Object> > myList;
    
    //First create some
    for (unsigned int i=0; i<NCREATE; ++i) {
	myList.push_back(pool.get());
    }
    BOOST_CHECK_EQUAL(pool.poolSize(), 0);
    BOOST_CHECK_EQUAL(Object::creationCount, NCREATE);
    BOOST_CHECK_EQUAL(Object::deletionCount, 0);
    BOOST_CHECK_EQUAL(Object::resetCount, 0);
    
    //Now delete them all
    myList.clear();
    BOOST_CHECK_EQUAL(pool.poolSize(), NCREATE);
    BOOST_CHECK_EQUAL(Object::creationCount, NCREATE);
    BOOST_CHECK_EQUAL(Object::deletionCount, 0);
    BOOST_CHECK_EQUAL(Object::resetCount, 0);
 
    //Now get another 10
    for (unsigned int i=0; i<NCREATE; ++i) {
	myList.push_back(pool.get());
    }
    BOOST_CHECK_EQUAL(pool.poolSize(), 0);
    BOOST_CHECK_EQUAL(Object::creationCount, NCREATE);
    BOOST_CHECK_EQUAL(Object::deletionCount, 0);
    BOOST_CHECK_EQUAL(Object::resetCount, NCREATE);
    
    //Now clear pool
    myList.clear();
    pool.clear();
    pool.resize(NCREATE);
    BOOST_CHECK_EQUAL(pool.poolSize(), NCREATE);
    BOOST_CHECK_EQUAL(Object::creationCount, 2*NCREATE);
    BOOST_CHECK_EQUAL(Object::deletionCount, NCREATE);
    BOOST_CHECK_EQUAL(Object::resetCount, NCREATE);

    //Now get another 10
    for (unsigned int i=0; i<NCREATE; ++i) {
	myList.push_back(pool.get());
    }
    BOOST_CHECK_EQUAL(pool.poolSize(), 0);
    BOOST_CHECK_EQUAL(Object::creationCount, 2*NCREATE);
    BOOST_CHECK_EQUAL(Object::deletionCount, NCREATE);
    BOOST_CHECK_EQUAL(Object::resetCount, 2*NCREATE);    
}

//Check that everything has been deleted correctly
void testPostPool() {
    BOOST_CHECK_EQUAL(Object::creationCount, 2*NCREATE);
    BOOST_CHECK_EQUAL(Object::deletionCount, 2*NCREATE);
    BOOST_CHECK_EQUAL(Object::resetCount, 2*NCREATE);        
}

ObjectPool_Test::ObjectPool_Test() {
    add(BOOST_TEST_CASE(&testPool));
    add(BOOST_TEST_CASE(&testPostPool));
}	
}
