#include "ModuleElement_Test.h"
#include "Sct/SctParameters.h"
#include "../src/ModuleElement.h"
#include <boost/test/unit_test.hpp>

using boost::unit_test_framework::test_suite;
using namespace Sct;

namespace SctData{
    
    void testCreation() {
	ModuleElement module = ModuleElement::Module();
	BOOST_CHECK_EQUAL(module.getFirst(), (unsigned)0);
	BOOST_CHECK_EQUAL(module.getLast(), nChannelModule-1);
	BOOST_CHECK_EQUAL(module.getNChannels(), nChannelModule);
	BOOST_CHECK(module.isModule());
	BOOST_CHECK(!module.isLink());
	BOOST_CHECK(!module.isChip());
	
	ModuleElement chip5 = ModuleElement::Chip(5);
	BOOST_CHECK_EQUAL(chip5.getFirst(), nChannelChip*5);
	BOOST_CHECK_EQUAL(chip5.getLast(), nChannelChip*6-1);
	BOOST_CHECK_EQUAL(chip5.getNChannels(), nChannelChip);
	BOOST_CHECK(!chip5.isModule());
	BOOST_CHECK(!chip5.isLink());
	BOOST_CHECK(chip5.isChip());
	
	ModuleElement link1 = ModuleElement::Link(1);
	BOOST_CHECK_EQUAL(link1.getFirst(), nChannelLink);
	BOOST_CHECK_EQUAL(link1.getLast(), nChannelLink*2-1);
	BOOST_CHECK_EQUAL(link1.getNChannels(), nChannelLink);
	BOOST_CHECK(!link1.isModule());
	BOOST_CHECK(link1.isLink());
	BOOST_CHECK(!link1.isChip());
	
	ModuleElement chan178 = ModuleElement::Channel(178);
	BOOST_CHECK_EQUAL(chan178.getFirst(), (unsigned)178);
	BOOST_CHECK_EQUAL(chan178.getLast(), (unsigned)178);
	BOOST_CHECK_EQUAL(chan178.getNChannels(), (unsigned)1);
	BOOST_CHECK(!chan178.isModule());
	BOOST_CHECK(!chan178.isLink());
	BOOST_CHECK(!chan178.isChip());
	
	ModuleElement element(562, 589);
	BOOST_CHECK_EQUAL(element.getFirst(), (unsigned)562);
	BOOST_CHECK_EQUAL(element.getLast(), (unsigned)589);
	BOOST_CHECK_EQUAL(element.getNChannels(), (unsigned)28);
	BOOST_CHECK(!element.isModule());
	BOOST_CHECK(!element.isLink());
	BOOST_CHECK(!element.isChip());
    }
    
    void testRelations() {
	ModuleElement ele1(562, 589);
	ModuleElement ele2(562, 589);
	ModuleElement ele3(590, 600);
	ModuleElement ele4(587, 592);
	ModuleElement ele5(570, 580);
	ModuleElement ele6(550, 563);
	ModuleElement ele7(550, 560);
	ModuleElement ele8(562, 590);
	ModuleElement ele9(561, 589);
	ModuleElement ele10(560, 590);
	
	//Equality:
	BOOST_CHECK(ele1==ele2);
	BOOST_CHECK(!(ele1==ele3));
	BOOST_CHECK(!(ele1==ele8));
	BOOST_CHECK(!(ele1==ele9));
	
	//Within:
	BOOST_CHECK(ele5.isWithin(ele1));
	BOOST_CHECK(ele2.isWithin(ele1));
	BOOST_CHECK(!ele3.isWithin(ele1));
	BOOST_CHECK(!ele4.isWithin(ele1));
	BOOST_CHECK(!ele6.isWithin(ele1));
	BOOST_CHECK(!ele7.isWithin(ele1));
	BOOST_CHECK(!ele8.isWithin(ele1));
	BOOST_CHECK(!ele9.isWithin(ele1));
	BOOST_CHECK(!ele10.isWithin(ele1));
	
	//Contains:
	BOOST_CHECK(ele10.contains(ele1));
	BOOST_CHECK(ele2.contains(ele1));
	BOOST_CHECK(!ele3.contains(ele1));
	BOOST_CHECK(!ele4.contains(ele1));
	BOOST_CHECK(!ele5.contains(ele1));
	BOOST_CHECK(!ele6.contains(ele1));
	BOOST_CHECK(!ele7.contains(ele1));
	BOOST_CHECK(ele8.contains(ele1));
	BOOST_CHECK(ele9.contains(ele1));
	
	//Overlaps:	
	BOOST_CHECK(ele2.overlaps(ele1));	
	BOOST_CHECK(!ele3.overlaps(ele1));
	BOOST_CHECK(ele4.overlaps(ele1));
	BOOST_CHECK(ele5.overlaps(ele1));
	BOOST_CHECK(ele6.overlaps(ele1));
	BOOST_CHECK(!ele7.overlaps(ele1));
	BOOST_CHECK(ele8.overlaps(ele1));
	BOOST_CHECK(ele9.overlaps(ele1));
	BOOST_CHECK(ele10.overlaps(ele1));
    }
    
    void testAdjacent() {
	ModuleElement ele1(420, 430);
	ModuleElement ele2(431, 435);
	ModuleElement ele3(436, 440);
	ModuleElement ele4(440, 445);
	ModuleElement ele5(231, 235);
	
	BOOST_CHECK(ele1.adjacentTo(ele2));
	BOOST_CHECK(ele2.adjacentTo(ele1));
	BOOST_CHECK(ele2.adjacentTo(ele3));
	BOOST_CHECK(ele3.adjacentTo(ele2));
	BOOST_CHECK(!ele3.adjacentTo(ele4));
	BOOST_CHECK(!ele4.adjacentTo(ele3));
	BOOST_CHECK(!ele5.adjacentTo(ele2));
	BOOST_CHECK(!ele2.adjacentTo(ele5));
    }
    
    ModuleElement_Test::ModuleElement_Test() {
	add(BOOST_TEST_CASE(&testCreation));
	add(BOOST_TEST_CASE(&testRelations));
	add(BOOST_TEST_CASE(&testAdjacent));
  }
}
